﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using static prj_wfrm_centreCall_tickets.tab;

namespace prj_wfrm_centreCall_tickets
{
    public partial class frmTechnicienAfficherTous : Form
    {
        public frmTechnicienAfficherTous()
        {
            InitializeComponent();
        }

        private void frmTechnicienAfficherTous_Load(object sender, EventArgs e)
        {
            if (tab.nbTechniciens == 0)
            {
                MessageBox.Show("Aucun technicien", "Information", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            else
            {
                //parcours du tableau des techniciens pour afficher les informations de chacun dans la ListView
                for (int i = 0; i < tab.nbTechniciens; i++)
                {
                    //configuration d'une ligne de la liste
                    ListViewItem ligne = new ListViewItem();
                    //1ère colonne = numéro du technicien
                    ligne.Text = tab.technicien[i].numero.ToString();
                    //2ème colonne = nom du technicien
                    ligne.SubItems.Add(tab.technicien[i].nomTech);
                    //3ème colonne = Prénom du technicien
                    ligne.SubItems.Add(tab.technicien[i].prenomTech);
                    //4ème colonne = taux horaire du technicien
                    ligne.SubItems.Add(tab.technicien[i].tauxHoraire.ToString());

                    //ajout de la ligne dans la ListView
                    lvTechnicien.Items.Add(ligne);
                }

                //On veut afficher dans une TextBox la moyenne du taux horaire des techniciens
                DataTable resultat = new DataTable();
                string sql = "select avg(TEC_TAUX_HORAIRE) as moy from tb_technicien;";
                resultat = Global.connexion(sql);
                //resultat contient désormais le résultat de notre requête

                double nombre = 0;
                foreach (DataRow valeur in resultat.Rows)
                {
                    nombre = Convert.ToDouble(valeur["moy"]); //On récupère la valeur de la moyenne dans une variable nombre
                }
                //On affiche la moyenne calculée par la requête SQL dans la TextBox concernée
                tb_tauxHoraireMoyen.Text = nombre.ToString();
            }
        }
    }
}
